/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.textannotations;

import filenet.vw.api.VWException;
import filenet.vw.api.VWTextAnnotationDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.canvas.process.VWDesignerBasePropertyPanel;
import filenet.vw.toolkit.design.canvas.process.VWPropertyMenuItem;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.table.VWColorListCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class VWTextAnnotationPropertyPanel
extends VWDesignerBasePropertyPanel
implements DocumentListener,
IVWPropertyChangeSource,
IVWPropertyChangeListener,
ActionListener,
ComponentListener {
    protected VWTextAnnotationDefinition m_selectedTextAnnotation = null;
    protected Vector m_changedItems = null;
    protected JTextField m_nameTextField;
    protected JTextArea m_messageTextArea;
    protected JComboBox m_colorCombo;

    public VWTextAnnotationPropertyPanel(VWAuthPropertyData authPropertyData) {
        super(authPropertyData);
        authPropertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
        this.addComponentListener(this);
    }

    public Object getDataObject() {
        return this.m_selectedTextAnnotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataObject(Object dataObject) {
        this.setEnabled(this.m_authPropertyData.isCurrentMapEditable());
        this.m_selectedTextAnnotation = (VWTextAnnotationDefinition)dataObject;
        try {
            try {
                this.m_nameTextField.getDocument().removeDocumentListener(this);
                this.m_messageTextArea.getDocument().removeDocumentListener(this);
                this.m_colorCombo.removeActionListener(this);
                this.m_nameTextField.setText("");
                this.m_messageTextArea.setText("");
                if (this.m_selectedTextAnnotation != null) {
                    this.m_nameTextField.setText(this.m_selectedTextAnnotation.getName());
                    this.m_messageTextArea.setText(this.m_selectedTextAnnotation.getMessage());
                    this.m_colorCombo.setSelectedItem(this.m_selectedTextAnnotation.getBgColor());
                }
                this.setEnabled(this.m_authPropertyData.isCurrentMapEditable());
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var4_3 = null;
                this.m_nameTextField.getDocument().addDocumentListener(this);
                this.m_messageTextArea.getDocument().addDocumentListener(this);
                this.m_colorCombo.addActionListener(this);
            }
            Object var4_2 = null;
            this.m_nameTextField.getDocument().addDocumentListener(this);
            this.m_messageTextArea.getDocument().addDocumentListener(this);
            this.m_colorCombo.addActionListener(this);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_nameTextField.getDocument().addDocumentListener(this);
            this.m_messageTextArea.getDocument().addDocumentListener(this);
            this.m_colorCombo.addActionListener(this);
            throw throwable;
        }
    }

    public String getDisplayName() {
        String name = this.getToolTip();
        if (name != null) {
            name = this.getFormattedTabName(name);
        }
        return name;
    }

    public String getToolTip() {
        if (this.m_selectedTextAnnotation != null) {
            return VWPropertyMenuItem.getDisplayName(this.m_selectedTextAnnotation);
        }
        return null;
    }

    public Icon getIcon() {
        return VWImageLoader.createImageIcon("text_annotation_16.gif");
    }

    public void displayHelpPage() {
        VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh158.htm");
    }

    public void releaseReferences() {
        this.m_authPropertyData.getPropertyChangeEventNotifier().removePropertyChangeListener(this);
        this.removeComponentListener(this);
        if (this.m_nameTextField != null) {
            this.m_nameTextField.getDocument().removeDocumentListener(this);
            this.m_nameTextField = null;
        }
        if (this.m_messageTextArea != null) {
            this.m_messageTextArea.getDocument().removeDocumentListener(this);
            this.m_messageTextArea.removeAll();
            this.m_messageTextArea = null;
        }
        if (this.m_colorCombo != null) {
            this.m_colorCombo.removeActionListener(this);
            this.m_colorCombo.removeAllItems();
            this.m_colorCombo = null;
        }
        super.releaseReferences();
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        this.handleDocumentEvent(event);
    }

    public void removeUpdate(DocumentEvent event) {
        this.handleDocumentEvent(event);
    }

    public void notifyPropertyChange() {
        this.m_changedItems = new Vector();
        this.m_changedItems.addElement(this.m_selectedTextAnnotation);
        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 572);
    }

    public Vector getItemsChanged() {
        return this.m_changedItems;
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        block6: {
            try {
                Object object = event.getSource();
                if (!(object instanceof IVWPropertyChangeSource) || object == this) break block6;
                IVWPropertyChangeSource source = (IVWPropertyChangeSource)object;
                switch (event.getID()) {
                    case 572: {
                        Vector items = source.getItemsChanged();
                        for (int nIndex = 0; nIndex < items.size(); ++nIndex) {
                            object = items.elementAt(nIndex);
                            if (object == null || !(object instanceof VWTextAnnotationDefinition) || object != this.m_selectedTextAnnotation) continue;
                            this.setDataObject(object);
                        }
                        break;
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource().equals(this.m_colorCombo)) {
                this.setSelectedBackgroundColor((Color)this.m_colorCombo.getSelectedItem());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void componentHidden(ComponentEvent event) {
    }

    public void componentMoved(ComponentEvent event) {
    }

    public void componentResized(ComponentEvent event) {
    }

    public void componentShown(ComponentEvent event) {
        if (this.m_authPropertyData.isCurrentMapEditable()) {
            this.m_messageTextArea.requestFocus();
            this.m_messageTextArea.requestFocusInWindow();
        }
    }

    protected void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 0;
            gbCons.insets = new Insets(5, 5, 5, 10);
            this.add((Component)this.getNamePanel(), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.gridwidth = -1;
            gbCons.insets = new Insets(0, 5, 5, 20);
            this.add((Component)this.getColorPanel(), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.gridwidth = 0;
            gbCons.insets = new Insets(0, 5, 0, 10);
            this.add((Component)this.getMessagePanel(), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getNamePanel() {
        try {
            VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_textAnnotation);
            JPanel clientPanel = toolbarBorder.getClientPanel();
            clientPanel.setLayout(new BorderLayout());
            this.m_nameTextField = new JTextField("", 15);
            this.m_nameTextField.setName("m_nameTextField_VWDiagramTextAnnotationPropertyPanel");
            this.m_controls.addElement(this.m_nameTextField);
            clientPanel.add((Component)this.m_nameTextField, "First");
            return toolbarBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getColorPanel() {
        try {
            VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_backgroundColor);
            JPanel clientPanel = toolbarBorder.getClientPanel();
            clientPanel.setLayout(new BorderLayout());
            this.m_colorCombo = new JComboBox<Color>(VWColorListCellRenderer.getAvailableColors());
            this.m_colorCombo.setName("m_colorCombo_VWTextAnnotationPropertyPanel");
            this.m_colorCombo.setRenderer(new VWColorListCellRenderer());
            this.m_colorCombo.addActionListener(this);
            clientPanel.add((Component)this.m_colorCombo, "First");
            this.m_controls.addElement(this.m_colorCombo);
            return toolbarBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getMessagePanel() {
        try {
            VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_messageStr);
            JPanel childPanel = toolbarBorder.getClientPanel();
            childPanel.setLayout(new BorderLayout());
            this.m_messageTextArea = new JTextArea();
            this.m_messageTextArea.setName("m_messageTextArea_VWTextAnnotationPropertyPanel");
            this.m_messageTextArea.setLineWrap(true);
            this.m_messageTextArea.setWrapStyleWord(true);
            this.m_messageTextArea.getDocument().addDocumentListener(this);
            childPanel.add((Component)new JScrollPane(this.m_messageTextArea), "Center");
            this.m_controls.addElement(this.m_messageTextArea);
            return toolbarBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void handleDocumentEvent(DocumentEvent event) {
        if (this.m_selectedTextAnnotation == null) {
            return;
        }
        if (event.getDocument() == this.m_nameTextField.getDocument()) {
            this.updateName();
        } else if (event.getDocument() == this.m_messageTextArea.getDocument()) {
            try {
                this.m_selectedTextAnnotation.setMessage(this.m_messageTextArea.getText());
                this.m_authPropertyData.setDirty();
                this.notifyPropertyChange();
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
            }
        }
    }

    private void updateName() {
        try {
            if (this.m_selectedTextAnnotation != null && this.m_nameTextField != null) {
                String name = this.m_nameTextField.getText();
                String blankName = VWPropertyMenuItem.getBlankName(this.m_selectedTextAnnotation);
                if ((name.length() == 0 || name.equals(blankName)) && this.m_selectedTextAnnotation.getName() == null) {
                    return;
                }
                this.m_selectedTextAnnotation.setName(name);
                this.m_authPropertyData.setDirty();
                this.notifyPropertyChange();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void setSelectedBackgroundColor(Color selectedColor) {
        try {
            if (this.m_selectedTextAnnotation != null) {
                this.m_selectedTextAnnotation.setBgColor(selectedColor);
                this.notifyPropertyChange();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

